---
title: Reading All The Cards with a Proxmark 3
date: 2024-11-28T10:10:01+00:00
draft: false
tags:
  - rfid
---
Ah yes, the Proxmark 3. Makes it ludicrously easy to copy RFID and NFC fobs and cards. Best of all, it's open source and has a large community around it, constantly developing new features and fixing issues.

# Disclaimer
Don't go around cloning cards you don't have permission to clone. You have been warned.
# Step 1: Get your hands on one
Proxmarks are easy to get a hold of, but it's worth being careful.
There are a couple of versions of the Proxmark:
- The Proxmark3 Easy, sold on AliExpress by many sellers, is the older version of the Proxmark. It's really cheap but can have mixed results - mixed reviews mean you may be in for a lottery as to if you get a working one or not.
	- Make sure you get a 512KB Flash version, not a 256! If you get the 256K version, you'll have to compile the firmware without features to get it to work.
	- This is the one I bought so these instructions apply mostly to it - if you have an RDV4 change `PLATFORM=PM3GENERIC` to `PLATFORM=PM3RDV4` in the compile step.
- The Proxmark3 RDV4 is the newer, sleeker, better version of the Proxmark hardware with an improved design and a SIM card reader. It's the default build target for when you're compiling the firmware, however it is quite expensive.

# Step 2: Flash the firmware
This is probably the most difficult part, especially if you're on Windows. Windows users, please go install [MSYS2](https://www.msys2.org/) and use that instead of command prompt.

If you want the latest and most detailed instructions, read the [official compilation instructions](https://github.com/RfidResearchGroup/proxmark3/blob/master/doc/md/Use_of_Proxmark/0_Compilation-Instructions.md) and the [advanced compilation parameters](https://github.com/RfidResearchGroup/proxmark3/blob/master/doc/md/Use_of_Proxmark/4_Advanced-compilation-parameters.md).

You'll need Git and build tools.

Firstly, clone the Proxmark repo:
```bash
git clone https://github.com/RfidResearchGroup/proxmark3
cd proxmark3
```

Then, checkout the latest version. At the time of writing this is `v4.19552`:
```bash
git checkout v4.19552
```

Create a file called `Makefile.platform` and inside it write this
```
PLATFORM=PM3GENERIC
```
Change `PM3GENERIC` to `PM3RDV4` if you're using an RDV4 instead of an Easy.

Compile:
```bash
make clean && make -j
```

To install the client so you can use it anywhere, use the following command:
```bash
sudo make install
```

Now plug your Proxmark in and run the following to flash your device:
```bash
./pm3-flash-all
```

If all goes well, run `pm3` to get to the client:
```bash
./pm3
```

# Step 3: Clone Some Cards
## Which card do I have?
Cards can be one of two frequencies, LF (125KHz) or HF (13.56MHz)
To identify a card, place it onto the LF antenna and run `lf search`.
If no results, place it on the HF antenna and run `hf search`.
## Paxton (LF Hitag2)
Paxton fobs and cards are hitag2 cards with the key `BDF5E846`. Place the fob or card on the LF antenna, then run the following in the pm3 client to dump it:

```
lf hitag dump -k BDF5E846
```

Here is some example output (not a real card):
```
[usb] pm3 --> lf hitag dump -k BDF5E846
[=] Authenticating to Hitag 2 in Password mode

[=] --- Tag Information ---------------------------
[+] UID...... 1234abcd
[+] TYPE..... PCF 7936
[+] Config... 0x06
[+]   00000110
[+]   0000 ... - RFU
[+]   ....0 .. - Password mode
[+]   .....11  - Hitag 2
[+]   .......0 - Manchester

[=] 
[=] ----------------------------------------------
[=]  #      | data        | ascii | lck | Info
[=] --------+-------------+-------+-----+---------
[=]  0/0x00 | 12 34 AB CD | ....  | L   | UID
[=]  1/0x01 | BD F5 E8 46 | ...F  | RW  | Pwd
[=]  2/0x02 | 20 F0 4F 4E |  .ON  | RW  | Key/Pwd
[=]  3/0x03 | 06 F9 07 C2 | ....  | RW  | Config
[=]  4/0x04 | AB EC 9C 4D | ....  | RW  | User
[=]  5/0x05 | CD EF 01 02 | ....  | RW  | User
[=]  6/0x06 | 00 00 00 00 | ....  | RW  | User
[=]  7/0x07 | 00 00 00 00 | ....  | RW  | User
[=] --------+-------------+-------+-----+---------
[=]  L = Locked, RW = Read Write, R = Read Only
[=]  FI = Fixed / Irreversible
[=] ----------------------------------------------
[=] 
[=] --- Possible de-scramble patterns -------------
[+] Paxton id... 65698397 | 0x3ea7a5d  ( isocard )
[=] 
[+] Saved 32 bytes to binary file `/home/joe/pm3/lf-hitag-1234ABCD-dump-004.bin`
[+] Saved to json file `/home/joe/pm3/lf-hitag-1234ABCD-dump-004.json`
```

Pages 4 and 5 hold the data for the fob which you can write to another Paxton fob with the commands:
```
lf hitag writer --27 -k BDF5E846 -p 4 -d ABEC9C4D
lf hitag writer --27 -k BDF5E846 -p 5 -d CDEF0102
```
... replacing `ABEC9C4D` and `CDEF0102` with your own data.

To write to a T5577, take note of the hex version of the paxton descramble pattern in the output (in this case `0x3ea7a5d`), and run the command:
```
lf em 410x clone --id 03ea7a5d
```
The `id` specified to the command must have an even number of digits, so add a 0 to the start if it's not long enough.

## EM4100 (LF)
To read from EM410x cards/fobs (including T5577s), run the following command:
```
lf em 410x reader
```

The tag will respond with an ID:
```
[usb] pm3 --> lf em 410x reader
[+] EM 410x ID 0003EA7A5D
```

## T5577 (LF)
Use the EM4100 command above to read the ID from a T5577. If you want all of the data from a T5577, run this:
```
lf t55xx dump
```